﻿using UnityEngine;
using System.Collections;

public class LVL3_DoorSwitch : StoryEvent
{
    private InteractTrigger m_Trigger;
    public Door m_FirstDoor;
    public Door m_OtherDoor;
    public Transform m_Position1;
    public Transform m_Position2;
    public Transform m_Position3;

    public override void StartStory()
    {
        base.StartStory();
        m_Trigger = GetComponentInChildren<InteractTrigger>();
        StartCoroutine("C_Switch");
    }

    private IEnumerator C_Switch()
    {
        // Wait the player use the door
        while (!m_Trigger.IsIn || InputManager.Instance.GetAxisValue(InputSettings.Movements.Vertical2D) <= 0f)
        {
            yield return 0;
        }

        m_Trigger.InteractCharacter.CharacterCanMove(false);
        m_Trigger.InteractCharacter.MustGoSomewhere(m_Position1.position, 0.5f);
        yield return new WaitForSeconds(0.5f);

        // TODO : Close the door
        m_FirstDoor.Close();
        yield return new WaitForSeconds(1f);
        // Move the character
        m_Trigger.InteractCharacter.Teleport(m_Position2.position);
        yield return new WaitForSeconds(1f);
        // Open the other door
        m_OtherDoor.Open();
        yield return new WaitForSeconds(1f);
        // The character pass through the door
        m_Trigger.InteractCharacter.MustGoSomewhere(m_Position3.position, 0.5f);
        yield return new WaitForSeconds(0.5f);
        // TODO : Close the door
        m_OtherDoor.Close();
        m_Trigger.InteractCharacter.CharacterCanMove(true);
        m_Finished = true;
    }
}